document.addEventListener('DOMContentLoaded', function () {
    const dropdownParents = document.querySelectorAll('.has-dropdown > a');

    dropdownParents.forEach(function (link) {
        link.addEventListener('click', function (e) { 
            e.preventDefault();

            // Close all other dropdowns
            document.querySelectorAll('.has-dropdown').forEach(item => {
                if (item !== this.parentElement) {
                    item.classList.remove('active');
                }
            });

            // Toggle this one
            this.parentElement.classList.toggle('active');
        });
    });

    // Optional: close dropdown when clicking outside
    document.addEventListener('click', function (e) {
        if (!e.target.closest('.has-dropdown')) {
            document.querySelectorAll('.has-dropdown').forEach(item => {
                item.classList.remove('active');
            });
        }
    });
});


// Navbar Ends Js //

$(document).ready(function(){

    $(".resnav").click(function(){
        $(".headernavigation").toggleClass("main");
      });


    window.addEventListener("scroll", () => {

        let navcontrol = document.querySelector (".navcontrol");
        if ( window.pageYOffset >= 350){
        
        
            navcontrol.classList.add  ("sticky");
        
        }else{
        
            navcontrol.classList.remove ( "sticky");
        }
        
        
        })

})

// Navbar Ends //

// Hero Slider Started //
$('.hero-slider-carousel').owlCarousel({
    loop:true,
    margin:10,
    nav:true,
    dots:false,
    autoplay:true,
      autoplayTimeout:4000,
      autoplayHoverPause:true,
      animateOut: 'fadeOut',  
      smartSpeed:1000,
    responsive:{
        0:{
            items:1
        },
        600:{
            items:1
        },
        1000:{
            items:1
        }
    }
}) 
  
// Hero Slideer Ends //

// Testimonial Slider //
$('.testimonial-slider').owlCarousel({
    loop:true,
    margin:10,
    nav:true,
    dots:false,
    autoplay:true,
      autoplayTimeout:4000,
      autoplayHoverPause:true, 
      smartSpeed:1000,
    responsive:{
        0:{
            items:1
        },
        600:{
            items:1
        },
        1000:{
            items:1
        }
    }
}) 
// Testimonial slider Ends //

// Partner Logo //
$('.partner-logo').owlCarousel({
    loop:true,
    margin:10,
    nav:false,
    dots:false,
    autoplay:true,
      autoplayTimeout:4000,
      autoplayHoverPause:true, 
      smartSpeed:1000,
    responsive:{
        0:{
            items:3
        },
        600:{
            items:3
        },
        1000:{
            items:5
        }
    }
}) 
//Partner logo//

// Counter Section 
const counters = document.querySelectorAll('.counter');

counters.forEach(counter => {
  const updateCount = () => {
    const target = +counter.getAttribute('data-target');
    let count = parseFloat(counter.innerText) || 20;

    const increment = target / 200; // Smaller increment for slower animation

    if (count < target) {
      count += increment;
      counter.innerText = Math.round(count) + '+';
      setTimeout(updateCount, 20); // Slower update frequency
    } else {
        counter.innerText = Math.round(count) + '+';
    }
  };

  updateCount();
});

// Counter Section Ends //    

 
  // Back to top button
    $(window).scroll(function () {
      if ($(this).scrollTop() > 300) {
          $('.back-to-top').fadeIn('slow');
      } else {
          $('.back-to-top').fadeOut('slow');
      }
  });
  $('.back-to-top').click(function () {
      $('html, body').animate({scrollTop: 0}, 1500, 'easeInOutExpo');
      return false;
  });
