<?php
if ( ! function_exists( 'amitabhktheme_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 */
function amitabhktheme_setup() {

    /**
     * Make theme available for translation.
     * Translations can be placed in the /languages/ directory.
     */
    load_theme_textdomain( 'amitabhktheme', get_template_directory() . '/languages' );

    /**
     * Add default posts and comments RSS feed links to &lt;head>.
     */
    add_theme_support( 'automatic-feed-links' );

    /**
     * Enable support for post thumbnails and featured images.
     */
    add_theme_support( 'post-thumbnails' );


    /**
     * Add support for two custom navigation menus.
     */
    register_nav_menus( array(
        'primary'   => __( 'Primary Menu', 'amitabhktheme' ),
        'secondary' => __('Secondary Menu', 'amitabhktheme' )
    ) );

    function add_class_li($classes,$item,$args){
      if (isset($args->li_class)) {
        $classes[] = $args->li_class;
      }
      if (isset($args->active_class) && in_array('current-menu-item',$classes)) {
        $classes[] = $args->active_class;
      }
      return $classes;
    }
    add_filter('nav_menu_css_class', 'add_class_li', 10, 3);

    function add_anchor_class($attr,$item,$args){
      if (isset($args->a_class)) {
        $attr['class'] = $args->a_class;
      }
      return $attr;
    }
    add_filter('nav_menu_link_attributes', 'add_anchor_class', 10, 3);

    /**
     * Enable support for the following post formats:
     * aside, gallery, quote, image, and video
     */
    add_theme_support( 'post-formats', array ( 'aside', 'gallery', 'quote', 'image', 'video' ) );
}
endif; // myfirsttheme_setup
add_action( 'after_setup_theme', 'amitabhktheme_setup' );

function amitabhktheme_scripts()
{
    wp_enqueue_style('amitabhk-style', get_stylesheet_uri(), array(), rand(111, 9999), 'all');

    // Theme block stylesheet.
    wp_enqueue_style('owl_carousel_style', get_template_directory_uri() . '/css/slick.css', array('amitabhk-style'), '20181230');

    wp_enqueue_script('jquerymain',  get_template_directory_uri() . '/js/jquery.min.js',  array(), '');
    wp_enqueue_script( 'slickjs', get_template_directory_uri() . '/js/slick.min.js', array());
    wp_enqueue_script( 'customjs', get_template_directory_uri() . '/js/custom.js', array(), rand(111, 9999), true);

}
add_action('wp_enqueue_scripts', 'amitabhktheme_scripts');

/**
 * Disable the emoji's
 */
function disable_emojis() {
    remove_action( 'wp_head', 'print_emoji_detection_script', 7 );

    // Remove from TinyMCE
    add_filter( 'tiny_mce_plugamitabhk', 'disable_emojis_tinymce' );
}
add_action( 'init', 'disable_emojis' );

function add_additional_class_on_li($classes, $item, $args) {
    if(isset($args->add_li_class)) {
        $classes[] = $args->add_li_class;
    }
    return $classes;
}
add_filter('nav_menu_css_class', 'add_additional_class_on_li', 1, 3);

add_filter( 'nav_menu_link_attributes', 'wpse156165_menu_add_class', 10, 3 );

function wpse156165_menu_add_class( $atts, $item, $args ) {
    $class = 'nav-link'; // or something based on $item
    $atts['class'] = $class;
    return $atts;
}


function create_contact_form_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'contact_form';

    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        id INT(11) NOT NULL AUTO_INCREMENT,
        name VARCHAR(255) NOT NULL,
        email VARCHAR(255) NOT NULL,
        phone VARCHAR(255) NOT NULL,
        message TEXT NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (id)

    ) $charset_collate;";

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    dbDelta($sql);
}
add_action('after_setup_theme', 'create_contact_form_table');


function create_enquiry_form_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'enquiry_form';

    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        id INT(11) NOT NULL AUTO_INCREMENT,
        name VARCHAR(255) NOT NULL,
        email VARCHAR(255) NOT NULL,
        phone VARCHAR(255) NOT NULL,
        course TEXT NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (id)
    ) $charset_collate;";

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    dbDelta($sql);
}

add_action('after_setup_theme', 'create_enquiry_form_table');




// Configure SMTP settings
function configure_smtp($phpmailer) {
    $phpmailer->isSMTP();
    $phpmailer->Host = 'server.digieportfolio.in';
    $phpmailer->SMTPAuth = true;
    $phpmailer->Port = 465;
    $phpmailer->Username = 'info@drgarimasarawgi.com';
    $phpmailer->Password = 'o@A4t23f4';
    $phpmailer->SMTPSecure = 'ssl';
    $phpmailer->From = 'info@drgarimasarawgi.com';
    $phpmailer->FromName = 'Acharya Dronacharya Website';
}
add_action('phpmailer_init', 'configure_smtp');
 
function handle_contact_form_submission() {
    if (isset($_POST['submit_btn'])) {
        global $wpdb;
        $table_name = $wpdb->prefix . 'contact_form';
 
        $name = sanitize_text_field($_POST['name']);
        $email = sanitize_email($_POST['mail']);
        $phone = sanitize_text_field($_POST['mobile']);
        $message = sanitize_textarea_field($_POST['message']);
 
        $wpdb->insert(
            $table_name,
            array(
                'name' => $name,
                'email' => $email,
                'phone' => $phone,
                'message' => $message
            ),
            array('%s', '%s', '%s', '%s')
        );
 
        $to = 'bivas.digiex@gmail.com';
        $subject = "New Service Form Submission";
        $body = "Name: $name\nEmail: $email\nPhone: $phone\nMessage: $message";
        $headers = array(
            'Content-Type: text/html; charset=UTF-8',
            'From: Acharya Dronacharya Classes <info@newtownmedipoint.in>'
        );
 
        wp_mail($to, $subject, $body, $headers);
 
        wp_redirect(home_url('/thank-you'));
        exit;
    }
}
add_action('wp', 'handle_contact_form_submission');

function handle_enquiry_form_submission() {
    if (isset($_POST['submit_enq'])) {
        global $wpdb;
        $table_name = $wpdb->prefix . 'enquiry_form';
 
        $name = sanitize_text_field($_POST['name']);
        $email = sanitize_email($_POST['mail']);
        $phone = sanitize_text_field($_POST['mobile']);
        $course = sanitize_textarea_field($_POST['course']);
 
        $wpdb->insert(
            $table_name,
            array(
                'name' => $name,
                'email' => $email,
                'phone' => $phone,
                'course' => $course
            ),
            array('%s', '%s', '%s', '%s')
        );
 
        $to = 'bivas.digiex@gmail.com';
        $subject = "New Admission Form Submission";
        $body = "Name: $name\nEmail: $email\nPhone: $phone\nEnquiry for class: $course";
        $headers = array(
            'Content-Type: text/html; charset=UTF-8',
            'From: Acharya Dronacharya Classes Admission request for online or offline classes <info@newtownmedipoint.in>'
        );
 
        wp_mail($to, $subject, $body, $headers);
 
        wp_redirect(home_url('/thank-you'));
        exit;
    }
}
add_action('wp', 'handle_enquiry_form_submission');

require get_template_directory() . '/inc/head-functions.php';

// WordPress Dynamic Meta Title & Description Functions
function wpp_dynamic_meta_tags() {
    // Only run on frontend, not in admin
    if (is_admin()) {
        return;
    }
    
    // Don't run if other SEO plugins are active
    if (defined('WPSEO_VERSION') || class_exists('RankMath') || class_exists('AIOSEO_Core')) {
        return;
    }
    
    global $post;
    $meta_title = '';
    $meta_description = '';
    
    // Single posts, pages, and custom post types
    if (is_singular() && is_object($post)) {
        // META TITLE
        $custom_meta_title = get_post_meta($post->ID, 'meta-title', true);
        
        if (!empty($custom_meta_title)) {
            $meta_title = $custom_meta_title;
        } else {
            // Fallback to post title + site name
            $meta_title = get_the_title($post) . ' | ' . get_bloginfo('name');
        }
        
        // META DESCRIPTION
        $custom_meta_description = get_post_meta($post->ID, 'meta-description', true);
        
        if (!empty($custom_meta_description)) {
            $meta_description = $custom_meta_description;
        } else {
            // Second priority: post excerpt
            if (has_excerpt($post->ID)) {
                $meta_description = get_the_excerpt($post);
            } else {
                // Third priority: first paragraph from content
                $content = get_post_field('post_content', $post->ID);
                if (!empty($content)) {
                    $content = strip_shortcodes($content);
                    $content = wp_strip_all_tags($content);
                    $meta_description = wp_trim_words($content, 25, '');
                }
            }
        }
    } 
    // Homepage/Front page
    elseif (is_home() || is_front_page()) {
        $meta_title = get_bloginfo('name');
        if (get_bloginfo('description')) {
            $meta_title .= ' | ' . get_bloginfo('description');
        }
        $meta_description = get_bloginfo('description');
        
        // If no site description, create a basic one
        if (empty($meta_description)) {
            $meta_description = 'Welcome to ' . get_bloginfo('name');
        }
    } 
    // Search results
    elseif (is_search()) {
        $search_query = get_search_query();
        $meta_title = !empty($search_query) ? 
            'Search Results for "' . $search_query . '" | ' . get_bloginfo('name') : 
            'Search | ' . get_bloginfo('name');
        $meta_description = !empty($search_query) ? 
            'Search results for "' . $search_query . '" on ' . get_bloginfo('name') : 
            'Search page on ' . get_bloginfo('name');
    }
    // 404 pages
    elseif (is_404()) {
        $meta_title = 'Page Not Found | ' . get_bloginfo('name');
        $meta_description = 'The page you are looking for could not be found on ' . get_bloginfo('name');
    }
    // All other archive pages (categories, tags, custom taxonomies, date archives, author pages)
    elseif (is_archive()) {
        // Try to get archive title and description
        $archive_title = get_the_archive_title();
        $archive_description = get_the_archive_description();
        
        // Clean archive title (remove "Category:", "Tag:", etc. prefixes)
        $clean_title = $archive_title;
        $prefixes = array('Category: ', 'Tag: ', 'Author: ', 'Archives: ', 'Month: ', 'Year: ');
        foreach ($prefixes as $prefix) {
            if (strpos($clean_title, $prefix) === 0) {
                $clean_title = substr($clean_title, strlen($prefix));
                break;
            }
        }
        
        $meta_title = $clean_title . ' | ' . get_bloginfo('name');
        
        if (!empty($archive_description)) {
            $meta_description = wp_strip_all_tags($archive_description);
        } else {
            $meta_description = 'Browse content for ' . $clean_title . ' on ' . get_bloginfo('name');
        }
    }
    // Default fallback for any other page type
    else {
        $meta_title = get_bloginfo('name');
        if (get_bloginfo('description')) {
            $meta_title .= ' | ' . get_bloginfo('description');
        }
        $meta_description = get_bloginfo('description') ?: 'Visit ' . get_bloginfo('name');
    }
    
    // Clean and output meta title
    if (!empty($meta_title)) {
        $meta_title = wp_strip_all_tags($meta_title);
        $meta_title = str_replace(array("\n", "\r", "\t", '"'), array(' ', ' ', ' ', "'"), $meta_title);
        $meta_title = trim(preg_replace('/\s+/', ' ', $meta_title));
        
        // Limit to 60 characters for SEO
        if (mb_strlen($meta_title) > 60) {
            $meta_title = mb_substr($meta_title, 0, 57) . '...';
        }
        
        echo '<title>' . esc_html($meta_title) . '</title>' . "\n";
    }
    
    // Clean and output meta description
    if (!empty($meta_description)) {
        $meta_description = wp_strip_all_tags($meta_description);
        $meta_description = str_replace(array("\n", "\r", "\t", '"'), array(' ', ' ', ' ', "'"), $meta_description);
        $meta_description = trim(preg_replace('/\s+/', ' ', $meta_description));
        
        // Limit to 155 characters for SEO
        if (mb_strlen($meta_description) > 155) {
            $meta_description = mb_substr($meta_description, 0, 152) . '...';
        }
        
        echo '<meta name="description" content="' . esc_attr($meta_description) . '">' . "\n";
    }
}

// Remove default WordPress title tag support if this function handles it
remove_action('wp_head', '_wp_render_title_tag', 1);
add_action('wp_head', 'wpp_dynamic_meta_tags', 1);

// Add meta box for ALL post types (posts, pages, custom post types)
function wpp_add_meta_box() {
    // Get all public post types
    $post_types = get_post_types(array('public' => true), 'names');
    
    // Remove attachment from the list (images, videos, etc.)
    if (isset($post_types['attachment'])) {
        unset($post_types['attachment']);
    }
    
    foreach ($post_types as $post_type) {
        add_meta_box(
            'wpp_meta_tags',
            'SEO Meta Tags',
            'wpp_meta_box_callback',
            $post_type,
            'normal',
            'high'
        );
    }
}
add_action('add_meta_boxes', 'wpp_add_meta_box');

// Meta box callback function
function wpp_meta_box_callback($post) {
    // Add nonce field for security
    wp_nonce_field('wpp_save_meta_tags_nonce', 'wpp_meta_tags_nonce');
    
    // Get current values
    $meta_title = get_post_meta($post->ID, 'meta-title', true);
    $meta_description = get_post_meta($post->ID, 'meta-description', true);
    
    $title_char_count = mb_strlen($meta_title);
    $desc_char_count = mb_strlen($meta_description);
    
    echo '<div style="padding: 10px 0;">';
    
    // Meta Title Field
    echo '<div style="margin-bottom: 20px;">';
    echo '<label for="wpp_meta_title_field"><strong>Custom Meta Title:</strong></label><br>';
    echo '<input type="text" id="wpp_meta_title_field" name="wpp_meta_title_field" value="' . esc_attr($meta_title) . '" style="width: 100%; max-width: 600px; margin-top: 5px;" placeholder="Enter a custom title for search engines (recommended: 50-60 characters)">';
    echo '<p class="description">Characters used: <span id="title-char-count">' . $title_char_count . '</span>/60 | <span id="title-char-status" style="font-weight: bold;">Good length</span></p>';
    echo '<p class="description" style="font-style: italic; color: #666;">Leave empty to use: "' . esc_html(get_the_title($post)) . ' | ' . esc_html(get_bloginfo('name')) . '"</p>';
    echo '</div>';
    
    // Meta Description Field
    echo '<div style="margin-bottom: 10px;">';
    echo '<label for="wpp_meta_description_field"><strong>Custom Meta Description:</strong></label><br>';
    echo '<textarea id="wpp_meta_description_field" name="wpp_meta_description_field" rows="3" style="width: 100%; max-width: 600px; margin-top: 5px;" placeholder="Enter a custom meta description for SEO (recommended: 120-155 characters)">' . esc_textarea($meta_description) . '</textarea>';
    echo '<p class="description">Characters used: <span id="desc-char-count">' . $desc_char_count . '</span>/155 | <span id="desc-char-status" style="font-weight: bold;">Good length</span></p>';
    echo '<p class="description" style="font-style: italic; color: #666;">Leave empty to use post excerpt or first paragraph</p>';
    echo '</div>';
    
    echo '</div>';
    
    // JavaScript for character counting
    ?>
    <script type="text/javascript">
    document.addEventListener('DOMContentLoaded', function() {
        // Meta Title Counter
        var titleField = document.getElementById('wpp_meta_title_field');
        var titleCharCount = document.getElementById('title-char-count');
        var titleCharStatus = document.getElementById('title-char-status');
        
        function updateTitleCharCount() {
            var length = titleField ? titleField.value.length : 0;
            if (titleCharCount) titleCharCount.textContent = length;
            
            if (titleCharStatus) {
                if (length < 30) {
                    titleCharStatus.textContent = 'Too short';
                    titleCharStatus.style.color = '#ff8c00';
                } else if (length >= 30 && length <= 60) {
                    titleCharStatus.textContent = 'Good length';
                    titleCharStatus.style.color = '#008000';
                } else {
                    titleCharStatus.textContent = 'Too long';
                    titleCharStatus.style.color = '#dc3232';
                }
            }
        }
        
        // Meta Description Counter
        var descField = document.getElementById('wpp_meta_description_field');
        var descCharCount = document.getElementById('desc-char-count');
        var descCharStatus = document.getElementById('desc-char-status');
        
        function updateDescCharCount() {
            var length = descField ? descField.value.length : 0;
            if (descCharCount) descCharCount.textContent = length;
            
            if (descCharStatus) {
                if (length < 120) {
                    descCharStatus.textContent = 'Too short';
                    descCharStatus.style.color = '#ff8c00';
                } else if (length >= 120 && length <= 155) {
                    descCharStatus.textContent = 'Good length';
                    descCharStatus.style.color = '#008000';
                } else {
                    descCharStatus.textContent = 'Too long';
                    descCharStatus.style.color = '#dc3232';
                }
            }
        }
        
        if (titleField) {
            titleField.addEventListener('input', updateTitleCharCount);
            updateTitleCharCount();
        }
        
        if (descField) {
            descField.addEventListener('input', updateDescCharCount);
            updateDescCharCount();
        }
    });
    </script>
    <?php
}

// Save meta tags
function wpp_save_meta_tags($post_id) {
    // Security checks
    if (!isset($_POST['wpp_meta_tags_nonce'])) {
        return $post_id;
    }
    
    if (!wp_verify_nonce($_POST['wpp_meta_tags_nonce'], 'wpp_save_meta_tags_nonce')) {
        return $post_id;
    }
    
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return $post_id;
    }
    
    // Check user permissions
    if (isset($_POST['post_type'])) {
        $post_type_obj = get_post_type_object($_POST['post_type']);
        if ($post_type_obj && !current_user_can($post_type_obj->cap->edit_post, $post_id)) {
            return $post_id;
        }
    }
    
    // Save meta title
    if (isset($_POST['wpp_meta_title_field'])) {
        $meta_title = sanitize_text_field($_POST['wpp_meta_title_field']);
        
        if (!empty($meta_title)) {
            update_post_meta($post_id, 'meta-title', $meta_title);
        } else {
            delete_post_meta($post_id, 'meta-title');
        }
    }
    
    // Save meta description
    if (isset($_POST['wpp_meta_description_field'])) {
        $meta_description = sanitize_textarea_field($_POST['wpp_meta_description_field']);
        
        if (!empty($meta_description)) {
            update_post_meta($post_id, 'meta-description', $meta_description);
        } else {
            delete_post_meta($post_id, 'meta-description');
        }
    }
    
    return $post_id;
}
add_action('save_post', 'wpp_save_meta_tags');